/*:
 * @target MZ
 * @plugindesc ピクチャの拡大縮小時にニアレストネイバー法を使用するプラグイン
 * @author ChatGPT
 *
 * @help NearestNeighborPictures.js
 *
 * このプラグインを導入すると、ピクチャを拡大・縮小する際に
 * 自動的にニアレストネイバー法（Nearest Neighbor）を使用するようになります。
 *
 * 特に設定項目はありません。プラグインを導入するだけで有効になります。
 */

(() => {
    const _Sprite_Picture_loadBitmap = Sprite_Picture.prototype.loadBitmap;
    Sprite_Picture.prototype.loadBitmap = function() {
        _Sprite_Picture_loadBitmap.call(this);
        if (this.bitmap) {
            this.bitmap.smooth = false; // ニアレストネイバーを適用
        }
    };

    const _Sprite_Picture_updateBitmap = Sprite_Picture.prototype.updateBitmap;
    Sprite_Picture.prototype.updateBitmap = function() {
        const name = this._pictureName;
        _Sprite_Picture_updateBitmap.call(this);
        if (this._pictureName !== name && this.bitmap) {
            this.bitmap.smooth = false; // 名前が変わった場合も再適用
        }
    };
})();
